/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade;

import com.cake.trading_floor.TradingFloor;
import com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade.PotentialMerchantOfferInfo;
import com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade.VillagerItemListingResolver;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PotentialVillagerTrade
implements Recipe<RecipeInput> {
    ResourceLocation id;
    int villagerLevel;
    VillagerProfession profession;
    PotentialMerchantOfferInfo offer;

    public static List<PotentialVillagerTrade> buildPotentialTrades(RegistryAccess provider, Level level) {
        ArrayList<PotentialVillagerTrade> trades = new ArrayList<PotentialVillagerTrade>();
        HashSet<PotentialMerchantOfferInfo> existingOffers = new HashSet<PotentialMerchantOfferInfo>();
        for (Map.Entry professionOffers : VillagerTrades.TRADES.entrySet()) {
            for (Int2ObjectMap.Entry levelOffers : ((Int2ObjectMap)professionOffers.getValue()).int2ObjectEntrySet()) {
                int index = 0;
                for (VillagerTrades.ItemListing listing : (VillagerTrades.ItemListing[])levelOffers.getValue()) {
                    PotentialMerchantOfferInfo offer = VillagerItemListingResolver.tryResolve(listing, provider, level);
                    if (offer != null && !existingOffers.contains(offer)) {
                        trades.add(new PotentialVillagerTrade(TradingFloor.asResource("trade_" + ((VillagerProfession)professionOffers.getKey()).name() + "_level_" + levelOffers.getIntKey() + "_" + index), levelOffers.getIntKey(), (VillagerProfession)professionOffers.getKey(), offer));
                        existingOffers.add(offer);
                    }
                    ++index;
                }
            }
        }
        return trades;
    }

    public PotentialVillagerTrade(ResourceLocation id, int villagerLevel, VillagerProfession profession, PotentialMerchantOfferInfo offer) {
        this.id = id;
        this.villagerLevel = villagerLevel;
        this.profession = profession;
        this.offer = offer;
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public PotentialMerchantOfferInfo getOffer() {
        return this.offer;
    }

    public RecipeSerializer<?> getSerializer() {
        throw new UnsupportedOperationException();
    }

    public RecipeType<?> getType() {
        throw new UnsupportedOperationException();
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }
}

